"use client"

import { useState, useEffect } from "react"
import { Button } from "@/components/ui/button"
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Input } from "@/components/ui/input"
import { useRouter, useSearchParams } from "next/navigation"

export default function Home() {
  const router = useRouter()
  const searchParams = useSearchParams()
  const [gameId, setGameId] = useState("")

  // Check if there's a game ID in the URL parameters
  useEffect(() => {
    const urlGameId = searchParams.get("room") || searchParams.get("game")
    if (urlGameId) {
      setGameId(urlGameId.toUpperCase())
    }
  }, [searchParams])

  const createGame = () => {
    const newGameId = Math.random().toString(36).substring(2, 8).toUpperCase()
    router.push(`/game/${newGameId}`)
  }

  const joinGame = () => {
    if (gameId.trim()) {
      router.push(`/game/${gameId.trim().toUpperCase()}`)
    }
  }

  return (
    <div className="min-h-screen bg-gradient-to-br from-purple-900 via-blue-900 to-indigo-900 flex items-center justify-center p-4">
      <Card className="w-full max-w-md bg-white/10 border-white/20">
        <CardHeader className="text-center">
          <CardTitle className="text-3xl font-bold text-white mb-2">🃏 Kostas Late Poker 🕐</CardTitle>
          <CardDescription className="text-purple-200">
            Create or join a game to bet on Kostas's lateness!
          </CardDescription>
        </CardHeader>
        <CardContent className="space-y-4">
          <Button onClick={createGame} className="w-full bg-green-600 hover:bg-green-700 text-white font-semibold py-3">
            Create New Game
          </Button>

          <div className="relative">
            <div className="absolute inset-0 flex items-center">
              <span className="w-full border-t border-white/20" />
            </div>
            <div className="relative flex justify-center text-xs uppercase">
              <span className="bg-transparent px-2 text-purple-200">Or</span>
            </div>
          </div>

          <div className="space-y-2">
            <Input
              placeholder="Enter Game ID..."
              value={gameId}
              onChange={(e) => setGameId(e.target.value.toUpperCase())}
              onKeyPress={(e) => e.key === "Enter" && joinGame()}
              className="bg-white/20 border-white/30 text-white placeholder:text-gray-400"
            />
            <Button
              onClick={joinGame}
              disabled={!gameId.trim()}
              className="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3"
            >
              Join Game
            </Button>
          </div>

          <div className="text-center text-sm text-purple-300 mt-6">
            <p className="mb-2">
              💡 <strong>Pro tip:</strong> Share direct links!
            </p>
            <div className="bg-white/10 rounded p-3 text-xs">
              <p className="text-purple-200">Example:</p>
              <code className="text-blue-300">yoursite.com/game/ABC123</code>
            </div>
          </div>
        </CardContent>
      </Card>
    </div>
  )
}
